unit FMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  StdCtrls, Buttons, ComCtrls, OleCtrls, Menus, Types, ExtCtrls, Spin,
  ZylGPSSimulator;

type

  TfrmMain = class(TForm)
    gbLat: TGroupBox;
    btnTransmit: TBitBtn;
    cmbLat: TComboBox;
    lblDegree: TLabel;
    lblMinute: TLabel;
    lblSecond: TLabel;
    gbLong: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    cmbLong: TComboBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    efLatDeg: TSpinEdit;
    efLatMin: TSpinEdit;
    efLatSec: TSpinEdit;
    efLongDeg: TSpinEdit;
    efLongMin: TSpinEdit;
    efLongSec: TSpinEdit;
    efHeading: TSpinEdit;
    efSpeed: TSpinEdit;
    efAltitude: TSpinEdit;
    ZylGPSSimulator: TZylGPSSimulator;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure btnTransmitClick(Sender: TObject);
  private
    { Private declarations }

  public
    { Public declarations }
 
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  cmbLat.ItemIndex := 0;
  cmbLong.ItemIndex := 0;
  ZylGPSSimulator.Open();
end;

procedure TfrmMain.btnTransmitClick(Sender: TObject);
begin
  ZylGPSSimulator.Latitude_Degree := efLatDeg.Value;
  ZylGPSSimulator.Latitude_Minute := efLatMin.Value;
  ZylGPSSimulator.Latitude_Second := efLatSec.Value;
  if cmbLat.Text = 'North' then
    ZylGPSSimulator.Latitude_Direction := North
  else
    ZylGPSSimulator.Latitude_Direction := South;
  ZylGPSSimulator.Longitude_Degree := efLongDeg.Value;
  ZylGPSSimulator.Longitude_Minute := efLongMin.Value;
  ZylGPSSimulator.Longitude_Second := efLongSec.Value;
  if cmbLong.Text = 'East' then
    ZylGPSSimulator.Longitude_Direction := East
  else
    ZylGPSSimulator.Longitude_Direction := West;
  ZylGPSSimulator.Altitude := efAltitude.Value;
  ZylGPSSimulator.Heading := efHeading.Value;
  ZylGPSSimulator.Speed := ZylGPSSimulator.KmhToKnots(efSpeed.Value);

  ZylGPSSimulator.Transmit();
end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ZylGPSSimulator.Close();
end;

end.
